RDVRM:      EQU 0x004A                  ; BIOS RDVRM
WRTVRM:     EQU 0x004D                  ; BIOS WRTVRM
FILVRM:     EQU 0x0056                  ; BIOS FILVRM
LDIRVM:     EQU 0x005C                  ; BIOS LDIRVM

    ORG 0xC000
    ; ********************************
	; パターンジェネレータテーブル・カラーテーブル設定
	; BASICプログラムでスクリーンモード等設定済の前提で呼び出すこと
    ; ********************************
	CALL SET_PTN_TBL
	CALL SET_COL_TBL
    CALL SET_SPRITE_PTN_TBL
	RET

SET_PTN_TBL:
	; PATTERN GENERATE TABLE
	; PAGE 0
	LD DE,0x0000
	CALL SET_PTN_TBL_1
	; PAGE 1
	LD DE,0x0800
	CALL SET_PTN_TBL_1
	; PAGE 2
	LD DE,0x1000

SET_PTN_TBL_1:
	LD HL,BANK_PATTERN_0
	LD BC,0x0800
	CALL LDIRVM
	RET

SET_COL_TBL:
	; COLOR TABLE
	; PAGE 0
	LD DE,0x2000
	CALL SET_COL_TBL_1
	; PAGE 1
	LD DE,0x2800
	CALL SET_COL_TBL_1
	; PAGE 2
	LD DE,0x3000

SET_COL_TBL_1:
	LD HL,BANK_COLOR_0
	LD BC,0x0800
	CALL LDIRVM
	RET

SET_SPRITE_PTN_TBL:
	LD DE,0x3800
	LD HL,SPRITE_PTN
	LD BC,19*32
	CALL LDIRVM
	RET

    ORG 0xC100
    ; ********************************
    ; 逆スクロールルーチン
    ; スクロール範囲：(5,1)-(27,20)
    ; ********************************
    LD HL,0x1A7B                        ; 処理開始VRAMアドレス (スクロール範囲の右下端)
    LD B,18                             ; 行数カウンタ 18行

    ; 外部ループ処理 開始
    ; 全行に対しての処理を行う
OUTLOOP:
    PUSH BC
    LD B,24                             ; 桁数カウンタ 24桁

    ; 内部ループ処理 開始
    ; 1行に対しての処理を行う
INLOOP:
    ; 1行上のVRAMアドレスのデータを読む
    PUSH BC
    PUSH HL
    LD BC,32                            ; BC=32
    SBC HL,BC                           ; HL=HL-BC ＝1行上のアドレスとなる
    CALL RDVRM                          ; BIOS RDVRM呼び出し
                                        ; - HL : 読み取るアドレス
                                        ; - A  : 読み取ったデータ
    POP HL
    POP BC

    ; 現在のVRAMアドレスにデータを書き込む
    CALL WRTVRM                         ; BIOS WRTVRM呼び出し
                                        ; - HL : 書き込み先のVRAMアドレス
                                        ; - A  : 書き込むデータ

    DEC HL                              ; ひとつ左のアドレスに移動
    DJNZ INLOOP                         ; B>0の間、INLOOPラベルにジャンプ
    ; 内部ループ処理 終了

    LD BC,0x0008                        ; 前回の処理終了アドレスから余白(左4文字＋右4文字=8文字分)を減算し、処理開始アドレスとする
    SBC HL,BC
    POP BC
    DJNZ OUTLOOP                        ; B>0の間、OUTLOOPラベルにジャンプ
    ; 外部ループ処理 終了

    ; 先頭行クリア
    LD HL,0x1824                        ; 処理開始VRAMアドレス
    LD BC,24                            ; 桁数カウンタ 24桁
    LD A,' '                            ; 空白を設定
    CALL FILVRM                         ; BIOS WRTVRM呼び出し
                                        ; - HL : 書き込み先のVRAMアドレス
                                        ; - BC : 書き込むデータ長
                                        ; - A  : 書き込むデータ
    
    RET

BANK_PATTERN_0:
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x1c, 0x1c, 0x18, 0x10, 0x0, 0x30, 0x30, 0x0
	DB 0x6c, 0x6c, 0x24, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x2c, 0x7e, 0xec, 0x6e, 0x7c, 0xec, 0x68, 0x0
	DB 0x10, 0x7c, 0xd2, 0x78, 0x14, 0xd2, 0x7c, 0x10
	DB 0x62, 0xa6, 0xcc, 0x18, 0x36, 0x6a, 0xce, 0x0
	DB 0x70, 0xc8, 0xc8, 0x70, 0xca, 0xc4, 0x7a, 0x0
	DB 0x1c, 0x1c, 0x4, 0x8, 0x0, 0x0, 0x0, 0x0
	DB 0x8, 0x10, 0x30, 0x30, 0x30, 0x10, 0x8, 0x0
	DB 0x10, 0x8, 0xc, 0xc, 0xc, 0x8, 0x10, 0x0
	DB 0x18, 0x5a, 0x3c, 0x18, 0x3c, 0x5a, 0x18, 0x0
	DB 0x0, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x30, 0x40
	DB 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x30, 0x0
	DB 0x0, 0x4, 0xc, 0x18, 0x30, 0x60, 0x0, 0x0
	DB 0x38, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x38, 0x0
	DB 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x0
	DB 0x38, 0x4c, 0xc, 0x38, 0x60, 0x60, 0x7c, 0x0
	DB 0x38, 0x4c, 0xc, 0x38, 0xc, 0x4c, 0x38, 0x0
	DB 0x1c, 0x2c, 0x4c, 0x4c, 0x7c, 0xc, 0xc, 0x0
	DB 0x7c, 0x60, 0x60, 0x78, 0xc, 0xc, 0x78, 0x0
	DB 0x38, 0x60, 0x60, 0x78, 0x64, 0x64, 0x38, 0x0
	DB 0x7c, 0xc, 0xc, 0x18, 0x18, 0x18, 0x18, 0x0
	DB 0x38, 0x4c, 0x4c, 0x38, 0x4c, 0x4c, 0x38, 0x0
	DB 0x38, 0x4c, 0x4c, 0x3c, 0xc, 0x8, 0x30, 0x0
	DB 0x0, 0x18, 0x18, 0x0, 0x0, 0x18, 0x18, 0x0
	DB 0x0, 0x18, 0x18, 0x0, 0x0, 0x18, 0x18, 0x20
	DB 0xc, 0x18, 0x30, 0x60, 0x30, 0x18, 0xc, 0x0
	DB 0x0, 0x0, 0x7e, 0x0, 0x7e, 0x0, 0x0, 0x0
	DB 0x60, 0x30, 0x18, 0xc, 0x18, 0x30, 0x60, 0x0
	DB 0x7c, 0xce, 0x8c, 0x18, 0x18, 0x0, 0x18, 0x0
	DB 0x38, 0x44, 0xb2, 0x6a, 0xca, 0xda, 0x6c, 0x0
	DB 0x1c, 0x38, 0x4c, 0x4c, 0x7c, 0x4c, 0xce, 0x0
	DB 0xfc, 0x66, 0x46, 0x7c, 0x46, 0x46, 0xfc, 0x0
	DB 0x78, 0xc4, 0xc2, 0xc0, 0xc0, 0xe6, 0x7c, 0x0
	DB 0xf8, 0x64, 0x62, 0x62, 0x62, 0x66, 0xfc, 0x0
	DB 0xfe, 0x62, 0x60, 0x7c, 0x60, 0x62, 0xfc, 0x0
	DB 0xfe, 0x62, 0x60, 0x7c, 0x60, 0x60, 0xe0, 0x0
	DB 0x7c, 0xc2, 0xc0, 0xce, 0xc2, 0xe2, 0x7c, 0x0
	DB 0xe6, 0x42, 0x62, 0x7e, 0xc2, 0xc2, 0xe6, 0x0
	DB 0x7c, 0x30, 0x10, 0x10, 0x10, 0x18, 0x7c, 0x0
	DB 0x7e, 0x1c, 0xc, 0xcc, 0x8c, 0x9c, 0x78, 0x0
	DB 0xce, 0x46, 0x4c, 0xf8, 0xcc, 0xcc, 0xee, 0x0
	DB 0xe0, 0x60, 0x62, 0x64, 0x64, 0x66, 0xfe, 0x0
	DB 0xe2, 0x76, 0x7e, 0x5a, 0x4a, 0xc2, 0xe6, 0x0
	DB 0xc6, 0x62, 0x72, 0x5a, 0x5a, 0xce, 0xc6, 0x0
	DB 0x1c, 0x4e, 0x46, 0xc6, 0xc6, 0xe4, 0x78, 0x0
	DB 0xbc, 0xc6, 0x46, 0x6c, 0x78, 0x60, 0xf0, 0x0
	DB 0x1c, 0x4e, 0x46, 0xc6, 0xd4, 0xe8, 0x76, 0x0
	DB 0xbc, 0xc6, 0x46, 0x6c, 0x70, 0x6a, 0xe6, 0x0
	DB 0x7e, 0xe2, 0xc4, 0x70, 0xc, 0x86, 0x7c, 0x0
	DB 0xfc, 0x92, 0x10, 0x30, 0x30, 0x30, 0x7c, 0x0
	DB 0x44, 0xc2, 0xc2, 0xc2, 0xc2, 0x64, 0x38, 0x0
	DB 0xcc, 0x86, 0x86, 0x4e, 0x4c, 0x38, 0x30, 0x0
	DB 0x4c, 0x86, 0x92, 0x92, 0xb6, 0x7e, 0x2c, 0x0
	DB 0xce, 0x66, 0x2c, 0x18, 0x2c, 0x64, 0xf6, 0x0
	DB 0xce, 0x66, 0x2c, 0x3c, 0x18, 0x18, 0x38, 0x0
	DB 0x7e, 0x84, 0x1c, 0x38, 0x70, 0xe2, 0xfe, 0x0
	DB 0x7c, 0x82, 0xba, 0xa2, 0xba, 0x82, 0x7c, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0xee, 0xea, 0x5b, 0x68, 0xb7, 0x67, 0x76, 0x2a
	DB 0x8, 0x4a, 0x0, 0xa, 0x0, 0xa4, 0x20, 0x44
	DB 0xb4, 0x20, 0x74, 0x28, 0x30, 0x38, 0x10, 0x10
	DB 0x50, 0x54, 0x44, 0x10, 0x0, 0x50, 0x0, 0x40
	DB 0x14, 0x54, 0x44, 0x10, 0x0, 0x14, 0x0, 0x4
	DB 0x80, 0x44, 0xa, 0x55, 0xe8, 0x42, 0x31, 0x20
	DB 0xff, 0x6d, 0xde, 0x77, 0xd6, 0x4a, 0x11, 0x0
	DB 0x60, 0xe6, 0xf6, 0xf0, 0x20, 0xc, 0x4e, 0x6
	DB 0x4, 0x1b, 0xa, 0xf, 0x6, 0xd, 0x7, 0x6
	DB 0xa8, 0xa8, 0x50, 0x50, 0xa0, 0x50, 0xa0, 0xe0
	DB 0x7, 0x3, 0x3, 0x3, 0x1, 0x1, 0x0, 0x0
	DB 0xe0, 0xc0, 0x40, 0x80, 0xc0, 0x80, 0x80, 0x80
	DB 0x0, 0x0, 0x42, 0x24, 0x0, 0x0, 0x0, 0x0
	DB 0x10, 0x10, 0x8, 0x10, 0x38, 0x3c, 0x28, 0x10
	DB 0x18, 0x8, 0x18, 0xdd, 0xff, 0x18, 0x18, 0x18
	DB 0x0, 0x46, 0x3c, 0xd7, 0xc3, 0x81, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x18, 0x26, 0xe, 0xc, 0x20, 0x55, 0x72, 0x20
	DB 0x86, 0x0, 0x70, 0x88, 0xc4, 0x18, 0x2c, 0x1c
	DB 0x0, 0x6, 0x33, 0x30, 0x6, 0xce, 0xcc, 0x0
	DB 0x0, 0x1c, 0x7f, 0x1c, 0x63, 0x2a, 0x1c, 0x8
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x3f, 0x3f, 0x3f, 0x1e, 0x1e, 0x1c, 0x1c
	DB 0x0, 0xbc, 0xbc, 0xbc, 0x3e, 0x3e, 0x7e, 0x77
	DB 0x0, 0xef, 0xef, 0xef, 0xdc, 0xdc, 0xdc, 0xdc
	DB 0x0, 0x7, 0x8f, 0x8e, 0xce, 0xde, 0xdc, 0xdc
	DB 0x0, 0xe, 0x1e, 0x3e, 0x36, 0x76, 0x66, 0xe6
	DB 0x0, 0x67, 0x67, 0x67, 0x77, 0xff, 0xfe, 0xfe
	DB 0x0, 0x7, 0xf, 0x1f, 0x3b, 0x33, 0x73, 0x7f
	DB 0x8, 0x1c, 0x3e, 0x7c, 0xf8, 0xf8, 0x7c, 0x3e
	DB 0x0, 0x71, 0x71, 0x71, 0x71, 0x71, 0x7f, 0x7f
	DB 0x0, 0x87, 0xcf, 0xdf, 0xdc, 0xd8, 0xd8, 0xd8
	DB 0x0, 0xf3, 0xc7, 0xe7, 0x77, 0x37, 0x37, 0x37
	DB 0x0, 0x9b, 0x9b, 0xdb, 0xdb, 0xfb, 0xfb, 0xfb
	DB 0x0, 0xfc, 0xf9, 0xfb, 0x3, 0xf3, 0xf1, 0xf0
	DB 0x40, 0xe0, 0xf0, 0xe0, 0xc0, 0xc0, 0xe0, 0xf0
	DB 0x4c, 0xaa, 0xaa, 0xaa, 0xea, 0xaa, 0xaa, 0x0
	DB 0xc0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xc0, 0x0
	DB 0xea, 0x4a, 0x4a, 0x4e, 0x4a, 0x4a, 0x4a, 0x0
	DB 0xe0, 0x80, 0x80, 0xe0, 0x80, 0x80, 0xe0, 0x0
	DB 0xa4, 0xa4, 0xa4, 0xe4, 0xa4, 0xa4, 0xa4, 0x0
	DB 0xcc, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xcc, 0x0
	DB 0xec, 0x8a, 0x8a, 0xea, 0x8a, 0x8a, 0xea, 0x0
	DB 0xe, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x0
	DB 0xce, 0xa8, 0xa8, 0xce, 0xa8, 0xa8, 0xae, 0x0
	DB 0x44, 0xaa, 0xa8, 0xa4, 0xe2, 0xaa, 0xa4, 0x0
	DB 0xac, 0xaa, 0xaa, 0xac, 0xaa, 0xaa, 0xea, 0x0
	DB 0xe0, 0x80, 0x80, 0xe0, 0x80, 0x80, 0xe0, 0x0
	DB 0x4c, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x0
	DB 0x4, 0xa, 0x8, 0x8, 0x8, 0xa, 0x4, 0x0
	DB 0x4a, 0xaa, 0xaa, 0xaa, 0xea, 0xaa, 0xa4, 0x0
	DB 0xe0, 0x80, 0x80, 0xe0, 0x80, 0x80, 0xe4, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x3c, 0x3c, 0x38, 0x38, 0x3e, 0xfe, 0xfe, 0xe0
	DB 0x77, 0xf7, 0xf7, 0xf3, 0xf3, 0xe0, 0x0, 0x0
	DB 0x98, 0xb9, 0xbf, 0xbf, 0xbe, 0x0, 0x0, 0x0
	DB 0xdc, 0x9d, 0xbd, 0x3d, 0x3d, 0x0, 0x0, 0x0
	DB 0xfe, 0xfe, 0xc6, 0xc6, 0xc0, 0x0, 0x0, 0x0
	DB 0xee, 0xee, 0xee, 0xe6, 0x0, 0x0, 0x0, 0x0
	DB 0x7f, 0xe3, 0xe7, 0xe7, 0x0, 0x0, 0x0, 0x0
	DB 0x1f, 0xf, 0xf, 0x1f, 0x7e, 0xfc, 0x78, 0x30
	DB 0x7f, 0x71, 0x71, 0x71, 0x70, 0x60, 0x0, 0x0
	DB 0xdc, 0xdf, 0xcf, 0xc7, 0x0, 0x0, 0x0, 0x0
	DB 0x77, 0xf7, 0xe7, 0xc7, 0x0, 0x0, 0x0, 0x0
	DB 0x7b, 0x7b, 0x3b, 0x3b, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0xf9, 0xf3, 0xf7, 0x3, 0x1, 0x0, 0x0
	DB 0xf0, 0xe0, 0xe0, 0xc0, 0x80, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
	DB 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0


BANK_COLOR_0:
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xf0, 0xf0, 0xf0
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x60, 0x60, 0x80, 0x60, 0x80, 0x90, 0x90, 0x90
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x40, 0x50, 0x40, 0x40, 0x50, 0x50, 0x40, 0x50
	DB 0x50, 0x50, 0x40, 0x40, 0x50, 0x50, 0x40, 0x40
	DB 0x50, 0x70, 0x40, 0x50, 0x40, 0x50, 0x40, 0x50
	DB 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50
	DB 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50
	DB 0xc0, 0xc0, 0x30, 0x20, 0xc0, 0x20, 0xc0, 0x20
	DB 0xb0, 0xa0, 0xb0, 0xa0, 0x90, 0xa0, 0x90, 0xa0
	DB 0x80, 0x80, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60
	DB 0xb0, 0xa0, 0xa0, 0xb0, 0xa0, 0x90, 0xa0, 0x90
	DB 0xb0, 0xa0, 0x90, 0xa0, 0x90, 0xa0, 0x90, 0x90
	DB 0xa0, 0x90, 0xa0, 0x90, 0x90, 0x90, 0x90, 0x90
	DB 0x90, 0xb0, 0x90, 0xa0, 0x90, 0x90, 0x90, 0x90
	DB 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
	DB 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0
	DB 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xe0
	DB 0x40, 0x40, 0x40, 0x48, 0x40, 0x40, 0x40, 0x40
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0xb0, 0x20, 0x20, 0x20, 0xb0, 0xb0, 0xb0, 0xb0
	DB 0xb0, 0xa0, 0xe0, 0xf0, 0xf0, 0xd0, 0xd0, 0xd0
	DB 0xb0, 0xf0, 0xa0, 0xa0, 0xa0, 0xf0, 0xb0, 0xb0
	DB 0x0, 0xf0, 0x70, 0x50, 0x70, 0x50, 0x50, 0x40
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x80, 0x90, 0x80, 0x90, 0xa0, 0x90, 0xa0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x80, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x90, 0x90, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xa0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0xa0, 0xb0, 0xa0, 0xb0, 0xe0, 0xb0, 0xe0, 0xb0
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10
	DB 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10


SPRITE_PTN:
	; 0 SHONES RIGHT1
    DB $04,$0A,$0C,$1A,$27,$40,$3F,$1E
    DB $1C,$0C,$1E,$2F,$1E,$22,$27,$12
    DB $30,$08,$08,$1E,$C1,$02,$FC,$04
    DB $04,$0C,$12,$F2,$9C,$14,$E8,$30
    ; 1 SHONES RIGHT1
    DB $03,$05,$03,$05,$18,$3F,$00,$01
    DB $03,$03,$01,$10,$01,$1D,$18,$0C
    DB $C0,$F0,$F0,$E0,$3E,$FC,$00,$A8
    DB $A8,$F0,$EC,$0C,$60,$E8,$10,$00
    ; 2 SHONES RIGHT2
    DB $03,$04,$0A,$0C,$1A,$27,$40,$3F
    DB $1E,$1C,$0C,$07,$0C,$0C,$07,$02
    DB $C0,$30,$08,$08,$1E,$C1,$02,$FC
    DB $04,$04,$08,$08,$F0,$D0,$E0,$20
    ; 3 SHONES RIGHT2
    DB $00,$03,$05,$03,$05,$18,$3F,$00
    DB $01,$03,$03,$00,$03,$03,$00,$01
    DB $00,$C0,$F0,$F0,$E0,$3E,$FC,$00
    DB $A8,$A8,$F0,$F0,$00,$20,$00,$C0
    ; 4 SHONES LEFT1
    DB $0C,$10,$10,$78,$83,$40,$3F,$20
    DB $20,$30,$48,$4F,$39,$28,$17,$0C
    DB $20,$50,$30,$58,$E4,$02,$FC,$78
    DB $38,$30,$78,$F4,$78,$44,$E4,$48
    ; 5 SHONES LEFT1
    DB $03,$0F,$0F,$07,$7C,$3F,$00,$15
    DB $15,$0F,$37,$30,$06,$17,$08,$00
    DB $C0,$A0,$C0,$A0,$18,$FC,$00,$80
    DB $C0,$C0,$80,$08,$80,$B8,$18,$30
    ; 6 SHONES LEFT2
    DB $03,$0C,$10,$10,$78,$83,$40,$3F
    DB $20,$20,$10,$10,$0F,$0B,$07,$04
    DB $C0,$20,$50,$30,$58,$E4,$02,$FC
    DB $78,$38,$30,$E0,$30,$30,$E0,$40
    ; 7 SHONES LEFT2
    DB $00,$03,$0F,$0F,$07,$7C,$3F,$00
    DB $15,$15,$0F,$0F,$00,$04,$00,$03
    DB $00,$C0,$A0,$C0,$A0,$18,$FC,$00
    DB $80,$C0,$C0,$00,$C0,$C0,$00,$80
    ; 8 SHONES MISS
    DB $00,$00,$0C,$12,$23,$24,$18,$3C
    DB $5F,$6F,$30,$40,$3F,$08,$08,$07
    DB $00,$00,$18,$24,$E2,$12,$0C,$5E
    DB $FD,$FF,$06,$01,$FE,$28,$58,$F0
    ; 9 SHONES MISS
    DB $00,$00,$00,$0C,$1C,$1B,$07,$03
    DB $20,$00,$0F,$3F,$00,$07,$07,$00
    DB $00,$00,$00,$18,$1C,$EC,$F0,$A0
    DB $02,$00,$F8,$FE,$00,$D0,$A0,$00
    ; 10 SIGHT
    DB $00,$3C,$60,$40,$40,$41,$01,$07
    DB $07,$01,$41,$40,$40,$60,$3C,$00
    DB $00,$3C,$06,$02,$02,$82,$80,$E0
    DB $E0,$80,$82,$02,$02,$06,$3C,$00
    ; 11 KNIFE
    DB $00,$00,$00,$01,$03,$02,$03,$02
    DB $03,$02,$0F,$03,$03,$03,$03,$00
    DB $00,$00,$80,$80,$00,$80,$00,$80
    DB $00,$80,$E0,$80,$80,$80,$80,$00
    ; 12 BAT 1
    DB $00,$00,$00,$E0,$76,$3A,$1F,$25
    DB $03,$02,$00,$00,$00,$00,$00,$00
    DB $00,$00,$00,$07,$6E,$5C,$F8,$A4
    DB $C0,$40,$00,$00,$00,$00,$00,$00
    ; 13 BAT 2
    DB $00,$00,$00,$22,$76,$7B,$CD,$93
    DB $02,$00,$00,$00,$00,$00,$00,$00
    DB $00,$00,$00,$44,$6E,$DE,$B3,$C9
    DB $40,$00,$00,$00,$00,$00,$00,$00
    ; 14 SKEKETON RIGHT 1
    DB $00,$01,$03,$03,$03,$01,$06,$0C
    DB $19,$0E,$18,$0E,$0C,$11,$70,$40
    DB $00,$F0,$A8,$28,$F8,$F0,$80,$60
    DB $00,$F0,$28,$28,$00,$80,$80,$C0
    ; 15 SKEKETON RIGHT 2
    DB $00,$00,$00,$01,$01,$01,$00,$03
    DB $06,$0D,$0E,$18,$0E,$0C,$12,$1B
    DB $00,$00,$F8,$D4,$94,$FC,$F8,$78
    DB $00,$00,$C0,$60,$50,$50,$00,$00
    ; 16 SKEKETON LEFT 1
    DB $00,$1F,$2B,$29,$3F,$1F,$02,$0C
    DB $01,$1E,$28,$28,$00,$03,$02,$06
    DB $00,$00,$80,$80,$80,$00,$C0,$60
    DB $30,$E0,$30,$E0,$60,$10,$1C,$04
    ; 17 SKEKETON LEFT 2
    DB $00,$00,$1F,$2B,$29,$3F,$1F,$1E
    DB $00,$00,$03,$06,$0A,$0A,$00,$00
    DB $00,$00,$00,$80,$80,$80,$00,$C0
    DB $60,$B0,$70,$18,$70,$30,$48,$D8
	; 18 "!!"
	DB $88,$DD,$7F,$7F,$F9,$79,$39,$79
	DB $F9,$7F,$39,$39,$7F,$7F,$EE,$84
	DB $8B,$DE,$FE,$FF,$9C,$9E,$9F,$9E
	DB $9C,$FE,$9F,$9E,$FC,$FE,$EE,$43
